unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, OleCtrls,  ActiveX, ComObj,
  SHDocVw, VideoSourceSrv_TLB;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    WebBrowser1: TWebBrowser;
    EditUrl: TEdit;
    BtnOpen: TButton;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnOpenClick(Sender: TObject);
  private
    { Private declarations }
    ImageWidth, ImageHeight:integer;
    BitmapDC:HDC;
    VSRC:IPC_CCTV_VideoSource;
    EventHandle:Thandle;
    FWaitObject: cardinal;

    PrevState:TConnectionState;
    procedure PCCCTVEventHandler;
    procedure PaintWebbrowser;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.PCCCTVEventHandler;
var
  state:TConnectionState;
begin
   State:=VSrc.ConnectionState;
   if (State<>TConnectionState_Idle) and VSrc.NeedCapture then
         PaintWebbrowser;
   if PrevState<>state then begin
     Label1.Caption:=Format('StreamViewed=%d MotionEventSubscribed=%d',
      [
      ord((state and TConnectionState_StreamViewed)<>0),
      ord((state and TConnectionState_MotionEventSubscribed)<>0)
      ]
    );
    PrevState:=state;
  end;
end;


procedure TForm1.BtnOpenClick(Sender: TObject);
begin
  WebBrowser1.navigate(EditUrl.text);
end;

procedure EventCallBack ( lparam: LPARAM; TimerOrWaitFired: Boolean); stdcall;
begin
  if not TimerOrWaitFired then begin
    with TForm1(lparam) do begin
           TThread.Synchronize(nil, PCCCTVEventHandler)
     end;
  end;
end;


procedure TForm1.FormCreate(Sender: TObject);
var
  St:string;
begin
  if ParamStr(1)<>'' then begin
       EditUrl.text:=StringReplace(ParamStr(1), '"', '', [RfReplaceAll]);
       WebBrowser1.navigate(EditUrl.text);
  end;
  PrevState:=$ff;
  ImageWidth:=960;
  ImageHeight:=720;
  try
    BitmapDC:=0;
    VSRC:= CreateComObject(CLASS_PC_CCTV_VideoSource) as IPC_CCTV_VideoSource;
    with VSRC do begin
      Width:=ImageWidth;
      Height:=ImageHeight;
      Name:='API browser simple sample';
      InactiveText:='API browser simple sample is off';
      PerformsMotionDetection:=false; //PC-CCTV performs motion detection
      SetEventForEachCapture:=true;   //The capture occurs by event
      VideoSourceUUID:='{1842B2F1-178A-4A5B-B7A8-ADE17BC88E99}';
      Active:=true;
      self.BitmapDC:=BitmapDC;
      self.EventHandle:=EventHandle;
    end;
    if not RegisterWaitForSingleObject(FWaitObject, EventHandle, @EventCallBack, self, Infinite, WT_EXECUTEDEFAULT) then
        FWaitObject:=0;
   except
    on E : EoleException do
      ShowMessage(Format ('%s The Hex errorCode is %x',[E.Message, E.ErrorCode ]));
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if FWaitObject<>0 then
     UnregisterWait(FWaitObject);
  VSRC:=nil;
end;

procedure TForm1.PaintWebbrowser;
var
  ViewObject: IViewObject;
  sourceDrawRect: TRect;
begin
  if WebBrowser1.Document <> nil then
  try
    WebBrowser1.Document.QueryInterface(IViewObject, ViewObject);
    if ViewObject <> nil then
      try
        sourceDrawRect := Rect(0, 0, ImageWidth, ImageHeight);
        ViewObject.Draw(DVASPECT_CONTENT {DVASPECT_THUMBNAIL}, 1, nil, nil, Self.Handle,
          BitmapDC, @sourceDrawRect, nil, nil, 0);
      finally
        ViewObject._Release;
      end;
  except
  end;
end;


end.
