unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, ActiveX,
  StdCtrls, ExtCtrls, ComCtrls, VideoSourceSrv_TLB, ComObj, Dialogs;

type
  TForm1 = class(TForm)
    BtnConnect: TButton;
    BtnDisconnect: TButton;
    StatusBar1: TStatusBar;
    Timer1: TTimer;
    Image1: TImage;
    CheckBoxDisplayImage: TCheckBox;
    Label1: TLabel;
    CheckBoxMotionDetected: TCheckBox;
    Memo1: TMemo;
    CheckBoxShowMemo: TCheckBox;
    procedure BtnConnectClick(Sender: TObject);
    procedure BtnDisconnectClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    BitmapCanvas:TCanvas;
    BitmapDC:HDC;
    VSRC:IPC_CCTV_VideoSource;
    EventHandle:Thandle;
    procedure ShowImage(DC:HDC; const aWidth:integer=0;const aHeight :integer=0);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BtnConnectClick(Sender: TObject);
begin
  VSRC.Set_Active(true);
  if not VSRC.Get_Active then begin
     showmessage(VSRC.LastErrorMessage);
     exit;
  end;
  BitmapDC:=VSRC.Get_BitmapDC;
  if BitmapDC<>0 then begin
        BitmapCanvas:=TCanvas.Create;
        BitmapCanvas.Handle:=BitmapDC;
        EventHandle:=VSRC.Get_EventHandle;
  end;
end;

procedure TForm1.ShowImage(DC:HDC; const aWidth:integer=0;const aHeight :integer=0);
var
  bmp:TBitmap;
  BitBltSuccess:boolean;
begin
    bmp:=Tbitmap.Create;
    bmp.PixelFormat:=pf24bit;
    bmp.SetSize(image1.Width, image1.Height);

    if aWidth<>0 then
       StretchBlt(bmp.Canvas.Handle, 0, 0, bmp.Width, bmp.Height, DC, 0, 0, aWidth, aHeight, SRCCOPY)
    else
       BitBltSuccess:=BitBlt(bmp.Canvas.Handle, 0, 0, bmp.Width, bmp.Height, DC, 0, 0, SRCCOPY);
    Image1.Picture.Assign(bmp);
    bmp.Free;
end;


procedure TForm1.BtnDisconnectClick(Sender: TObject);
begin
  BitmapDC:=0;
  EventHandle:=0;
  VSRC.Set_Active(false);
  if VSRC.Get_Active then
     showmessage(VSRC.LastErrorMessage);
  FreeAndNil(BitmapCanvas);
end;


procedure TForm1.FormCreate(Sender: TObject);
var
  St:string;
begin
 try
  BitmapDC:=0;
  VSRC:= CreateComObject(CLASS_PC_CCTV_VideoSource) as IPC_CCTV_VideoSource;
  with VSRC do begin
    Width:=640;
    Height:=480;
    Name:='API simple sample';
    InactiveText:='API simple sample is off';
    VideoSourceUUID:='{7083CFA3-D5B6-4421-A658-3E297086BABE}';
  end;
 except
  on E : EoleException do
    ShowMessage(Format ('%s The Hex errorCode is %x',[E.Message, E.ErrorCode ]));
 end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   VSRC:=nil;
   FreeAndNil(BitmapCanvas);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
 prevSelStart:integer;
 state:TConnectionState;
begin
   if BitmapDC<>0 then begin
     if (EventHandle<>0) and (WaitForSingleObject(EventHandle, 0)=WAIT_OBJECT_0) then begin
       state:= VSrc.ConnectionState;
       Label1.Caption:=Format('Streaming=%d MotionDetection=%d',
        [
          ord((state and TConnectionState_StreamViewed)<>0),
          ord((state and TConnectionState_MotionEventSubscribed)<>0)
        ]
       );
     end;
     if CheckBoxMotionDetected.Checked then
         VSrc.PictureWasChanged;
     if CheckBoxShowMemo.Checked then begin
        Memo1.Lines.BeginUpdate;
        prevSelStart:=Memo1.SelStart;
        if Memo1.Lines.Count>0 then
           Memo1.Lines[0]:=DateTimeToStr(now);
        Memo1.SelStart:=prevSelStart;
        Memo1.Lines.EndUpdate;
        Memo1.PaintTo(BitmapDC, 0 ,0);
     end else begin
       with BitmapCanvas do begin
         Lock;
         Brush.Color:=rgb(0, $8b, $8b);
         FillRect(rect(0, 0, VSrc.Get_width, VSrc.Get_Height));
         Font.Color := clWhite;
         Font.Size := 30;
         Font.Style := [fsBold];
         TextOut(30, 80, '== '+DateTimeToStr(now)+'==');
         UnLock;
       end;
     end;
   end;
//     bitmap.Canvas.TextOut(10,10, DateTimeToStr(now));
   if CheckBoxDisplayImage.checked and (BitmapDC<>0) then begin
        Image1.Visible:=true;
        ShowImage(BitmapDC);
   end else
        Image1.Visible:=false;
end;

end.
